implementation module CMVisualization

import CMTypes
import CMUtilities
import iDataFormlib
import StdiTasks


// View types	         
:: HtmlPrompt = HtmlPrompt String                
                   
gForm{|HtmlPrompt|} (init, formid) hst = ( { changed = False
                                           , value   = formid.ival
                                           , form    = [Txt label]
                                           }
                                         , hst)
  where (HtmlPrompt label) = formid.ival
  
gUpd{|HtmlPrompt|} (UpdCreate x) _   = (UpdCreate x, undef)
gUpd{|HtmlPrompt|} mode          val = (mode, val) 

derive gParse HtmlPrompt
derive gPrint HtmlPrompt     

                
:: HtmlPaper = HtmlPaper Paper

gForm{|HtmlPaper|} (init, formId) hst = ( { changed = False
                                          , value   = formId.ival
                                          , form    = toTable paperFormat paper
                                          }
                                        , hst)
                                          
  where (HtmlPaper paper) = formId.ival    
  

gUpd{|HtmlPaper|} (UpdCreate x) _   = (UpdCreate x, undef)
gUpd{|HtmlPaper|} mode          val = (mode, val) 

derive gParse HtmlPaper
derive gPrint HtmlPaper     


:: HtmlMatrix a = HtmlMatrix [String] [String] [[a]] 

gForm {|HtmlMatrix|} gFormA (init, formId) hst # (form, hst) = gFormLists xss hst
                                               = ( { changed = form.changed
                                                   , form    = [Table tstyle [tcolumnh : trowh form.form]] 
                                                   , value   = HtmlMatrix rows columns form.value
                                                   }
                                                 , hst)
  where (HtmlMatrix rows columns xss) = formId.ival
        
        gFormLists []         hst = ( { changed = False
                                      , value   = []
                                      , form    = []
                                      }
                                    , hst)
        gFormLists [xs:xss] hst # (formxs , hst) = gFormList xs  hst
                                # (formxss, hst) = gFormLists xss hst
                                = ( { changed = formxs.changed || formxss.changed
                                    , value   = [formxs.value : formxss.value]
                                    , form    = [Tr [] formxs.form] ++ formxss.form
                                    }
                                  , hst)
        
        gFormList []           hst = ( { changed = False
                                       , value   = []
                                       , form    = []
                                       }
                                     , hst)                
        gFormList [x:xs] hst # (formx , hst) = gFormA (init, reuseFormId formId x) hst 
                             # (formxs, hst) = gFormList xs hst
                             = ( { changed = formx.changed || formxs.changed 
                                 , value   = [formx.value : formxs.value]
                                 , form    = [Td [] formx.form] ++ formxs.form
                                 }
                               , hst) 
          where (HtmlPrompt label, (_, HideMode (paper, user))) = x
                
        tstyle :: [Table_Attr]
        tstyle = [Tbl_Border 1, Tbl_Width (Pixels 600)] 
        
        tcolumnh :: BodyTag
        tcolumnh = Tr [] [Td [] [] : map (\x -> Td [] [Txt x]) columns]
        
        trowh :: HtmlCode -> HtmlCode
        trowh trs = [Tr [] [Td [] [Txt row] : tds] \\ (Tr [] tds) <- trs & row <- rows ]
        
gUpd{|HtmlMatrix|} _     (UpdCreate x) _   = (UpdCreate x, undef)
gUpd{|HtmlMatrix|} gUpdA mode          val # (mode, xss) = gUpdLists mode xss
	                                       = (mode, HtmlMatrix rows columns xss)
  where (HtmlMatrix rows columns xss) = val

        gUpdLists mode []       = (mode, [])
		gUpdLists mode [xs:xss] # (mode, xs)  = gUpdList mode xs
                                # (mode, xss) = gUpdLists mode xss
                                = (mode, [xs:xss]) 
                  
        gUpdList mode []     = (mode, [])                    
        gUpdList mode [x:xs] # (mode, x)  = gUpdA mode x
                             # (mode, xs) = gUpdList mode xs
                             = (mode, [x:xs])                       
        
derive gParse HtmlMatrix
derive gPrint HtmlMatrix        


:: FixedList a = HorList [a]
               | VerList [a]

gForm{|FixedList|} gFormA (init, formId) hst # (form, hst) = gFormList xs hst
                                             = ({form & value = constr form.value}, hst)
  where (f, constr, xs) = case formId.ival of
                              HorList xs -> ((<=>) , HorList, xs)
                              VerList xs -> ((<||>), VerList, xs)
                              
        gFormList []     hst = ( { changed = False
                                 , value   = []
                                 , form    = []
                                 }
                               , hst)
        gFormList [x]    hst # (formx, hst) = gFormA (init, reuseFormId formId x) hst                 
                             = ( { changed = formx.changed
                                 , value   = [formx.value]
                                 , form    = formx.form
                                 }
                               , hst)
        gFormList [x:xs] hst # (formx, hst)  = gFormA (init, reuseFormId formId x) hst
                             # (formxs, hst) = gFormList xs hst  
                             = ( { changed = formx.changed || formxs.changed
                                 , value   = [formx.value : formxs.value]
                                 , form    = [f [f formx.form [Br, Hr [], Br]] formxs.form]
                                 }
                               , hst)  

gUpd{|FixedList|} _     (UpdCreate x) _   = (UpdCreate x, undef)
gUpd{|FixedList|} gUpdA mode          val # (mode, xs) = gFormList mode xs
	                                      = (mode, constr xs)
  where (constr, xs) = case val of
                         HorList xs -> (HorList, xs)
                         VerList xs -> (VerList, xs)

        gFormList mode []     = (mode, [])
		gFormList mode [x:xs] # (mode, x)  = gUpdA mode x
                              # (mode, xs) = gFormList mode xs
                              = (mode, [x:xs])

derive gParse FixedList
derive gPrint FixedList


// Formatting functions for users
formatUserList :: ([User] -> HtmlCode)
formatUserList = toTables userFormat

userFormat :: [(String, User -> String)]
userFormat = [ ("uid", \x -> toString x.uid_)
             , ("name", \x -> x.User.login.loginName)
             , ("email", \x -> fromTextInput x.User.email)
             , ("role", \x -> printToString x.role)
             ]
             
              
// Formatting functions for papers   
formatPaperList :: ([Paper] -> HtmlCode)
formatPaperList = toTables paperFormat

paperFormat :: [(String, Paper -> String)]
paperFormat = [ ("pid", \x -> toString x.pid_)
              , ("title", \x -> fromTextInput x.title)
              , ("author", \x -> fromTextInput x.author)
              , ("affiliation", \x -> fromTextInput x.affiliation)
              , ("email", \x -> fromTextInput x.Paper.email)
              , ("url", \x -> fromTextInput x.url)
              , ("abstract", \x -> fromTextArea x.abstract)
              ]      
             
            
// Formatting functions for reviews                                   
formatReviewList :: ([Review] -> HtmlCode)
formatReviewList = toTables reviewFormat 

reviewFormat :: [(String, Review -> String)]
reviewFormat = [ ("rid", \x -> toString x.rid_)
               , ("paper", \x -> toString x.Review.paper_)
               , ("reviewer", \x -> toString x.reviewer_)
               , ("expertise", \x -> expertiseScale !! fromRadioGroup x.expertise)
               , ("verdict", \x -> verdictScale !! fromRadioGroup x.verdict)
               , ("commentsAuthor", \x -> fromTextArea x.commentsAuthor)
               , ("commentsPC", \x -> fromTextArea x.commentsPC)
               ]    
               
expertiseScale :: [String]
expertiseScale = ["Novice", "Intermediate", "Expert"]

verdictScale :: [String]
verdictScale = ["Reject", "Neutral", "Accept"]
 
 
// General formatting functions               
toTables :: [(String, a -> String)] [a] -> HtmlCode
toTables fs xs = intersperseList [Br, Hr [], Br] (flatten (map (toTable fs) xs))

toTable :: [(String, a -> String)] a -> HtmlCode
toTable fs x = [Table tstyle tcells]
  where tstyle :: [Table_Attr]
        tstyle = [Tbl_Border 1, Tbl_Width (Pixels 600)]
   
        tcells :: HtmlCode
        tcells = map (\(h, f) -> Tr [] [ Td [] [Txt h]
                                       , Td [] [Txt (f x)]
                                       ]
                     ) fs